﻿using UnityEngine;

[RequireComponent(typeof(BoxCollider)), DisallowMultipleComponent]
public class Item : MonoBehaviour
{
    public delegate void CollisionEvent(GameObject _gameObject);
    public event CollisionEvent OnCollision;
    
    private void OnTriggerEnter(Collider _collider)
    {
        OnCollision(_collider.gameObject);
        
        GameObject.Destroy(gameObject);
    }
}
